import subprocess
from azure.ai.inference.prompts import PromptTemplate
from azure.ai.projects import AIProjectClient
from azure.identity import DefaultAzureCredential

# Configura la conexión a Azure AI Services
project_connection_string = "https://francecentral.api.azureml.ms;8369870d-da75-4ebb-9ca3-2111fd8dcebd;rg-jacintogau-5247_ai;aplicationtest"
project = AIProjectClient.from_connection_string(
    conn_str=project_connection_string, credential=DefaultAzureCredential()
)
chat = project.inference.get_chat_completions_client()

def get_chat_response(messages, context):
    # Instruir a la IA para que actúe como ingeniero de Azure y devuelva solo el comando CLI
    prompt_template = PromptTemplate.from_string(
        prompt_template="""
        system:
        You are a seasoned Azure engineer. Your task is to provide the exact Azure CLI command needed 
        to perform the requested operation on Azure. Respond ONLY with the command and nothing else. 
        Do not include any explanations or additional text.

        The user's context:
        First name: {{first_name}}
        Last name: {{last_name}}
        """
    )
    system_message = prompt_template.create_messages(data=context)
    return chat.complete(
        model="gpt-4o-mini",
        messages=system_message + messages,
        temperature=0.0,
        frequency_penalty=0,
        presence_penalty=0,
    )

def execute_command(command):
    # Ejecuta el comando utilizando subprocess (usa shell=True con precaución)
    print("Ejecutando comando:", command)
    try:
        result = subprocess.run(command, shell=True, check=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
        print("Salida:\n", result.stdout)
    except subprocess.CalledProcessError as e:
        print("Error al ejecutar el comando:\n", e.stderr)

if __name__ == "__main__":
    # Define el contexto del usuario (ajústalo según necesites)
    context = {"first_name": "Jessie", "last_name": "Irwin"}
    conversation = []

    print("Bienvenido al chatbot interactivo para Azure CLI. Escribe 'exit' para salir.\n")
    while True:
        user_input = input("Tú: ")
        if user_input.lower() in ("exit", "quit"):
            break
        
        # Agrega el mensaje del usuario al historial
        conversation.append({"role": "user", "content": user_input})
        
        # Solicita a la IA que genere el comando Azure CLI
        response = get_chat_response(conversation, context)
        azure_cli_command = response.choices[0].message.content.strip()
        
        print("\nComando Azure CLI sugerido por el asistente:")
        print(azure_cli_command, "\n")
        
        # Pide confirmación para ejecutar el comando
        confirm = input("¿Ejecutar este comando? (s/n): ")
        if confirm.lower() == "s":
            execute_command(azure_cli_command)
        else:
            print("Comando no ejecutado.\n")
        
        # Guarda la respuesta en el historial para mantener el contexto
        conversation.append({"role": "assistant", "content": azure_cli_command})
