from azure.ai.inference.prompts import PromptTemplate
from azure.ai.projects import AIProjectClient
from azure.identity import DefaultAzureCredential

# Configura la conexión a Azure AI Services
project_connection_string = "Project URL"

project = AIProjectClient.from_connection_string(
    conn_str=project_connection_string, credential=DefaultAzureCredential()
)

chat = project.inference.get_chat_completions_client()

def get_chat_response(messages, context):
    # Crea el mensaje del sistema a partir de un template
    prompt_template = PromptTemplate.from_string(
        prompt_template="""
        system:
        You are an AI assistant that speaks like a techno punk rocker from 2350. Be cool but not too cool. Ya dig?
        Refer to the user by their first name, try to work their last name into a pun.

        The user's first name is {{first_name}} and their last name is {{last_name}}.
        """
    )
    system_message = prompt_template.create_messages(data=context)
    
    # Envía el prompt al servicio combinando el mensaje del sistema y el historial de conversación
    return chat.complete(
        model="gpt-4o-mini",
        messages=system_message + messages,
        temperature=1,
        frequency_penalty=0.5,
        presence_penalty=0.5,
    )

if __name__ == "__main__":
    # Definir el contexto (puedes ajustarlo según necesites)
    context = {"first_name": "Jessie", "last_name": "Irwin"}
    
    # Inicializamos el historial de conversación (sin incluir el mensaje del sistema, que se genera dinámicamente)
    conversation = []
    
    print("Bienvenido al Chatbot. Escribe 'exit' para salir.\n")
    while True:
        user_input = input("Tú: ")
        if user_input.lower() in ("exit", "quit"):
            break
        
        # Agregar el mensaje del usuario al historial
        conversation.append({"role": "user", "content": user_input})
        
        # Obtener la respuesta del chatbot
        response = get_chat_response(conversation, context)
        assistant_message = response.choices[0].message.content
        
        print("Asistente:", assistant_message, "\n")
        
        # Agregar la respuesta del asistente al historial para mantener el contexto de la conversación
        conversation.append({"role": "assistant", "content": assistant_message})
hol