import subprocess
from azure.ai.inference.prompts import PromptTemplate
from azure.ai.projects import AIProjectClient
from azure.identity import DefaultAzureCredential
from kubernetes import client, config

# Configuración de la conexión a Azure AI Services
project_connection_string = "Project URL"
project = AIProjectClient.from_connection_string(
    conn_str=project_connection_string, credential=DefaultAzureCredential()
)
chat = project.inference.get_chat_completions_client()

# Cargar la configuración de Kubernetes (se asume que tienes un kubeconfig configurado)
config.load_kube_config()

def get_chat_response(messages, context):
    # Instruir a la IA para que actúe como un ingeniero de Kubernetes y devuelva solo el comando kubectl
    prompt_template = PromptTemplate.from_string(
        prompt_template="""
        system:
        You are a seasoned Kubernetes engineer. Your task is to provide the exact kubectl command needed to execute the requested operation on an AKS cluster.
        Respond ONLY with the command, and nothing else. Do not include any explanations or additional text.

        The user's context:
        First name: {{first_name}}
        Last name: {{last_name}}
        """
    )
    system_message = prompt_template.create_messages(data=context)
    
    # Puedes ajustar temperature, frequency_penalty y presence_penalty para obtener respuestas más determinísticas
    return chat.complete(
        model="gpt-4o-mini",
        messages=system_message + messages,
        temperature=0.0,
        frequency_penalty=0,
        presence_penalty=0,
    )

def execute_command(command):
    # Ejecuta el comando utilizando subprocess (usa shell=True con precaución)
    print("Ejecutando comando:", command)
    try:
        result = subprocess.run(command, shell=True, check=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
        print("Salida:\n", result.stdout)
    except subprocess.CalledProcessError as e:
        print("Error al ejecutar el comando:\n", e.stderr)

if __name__ == "__main__":
    # Contexto del usuario (puedes modificarlo)
    context = {"first_name": "Jessie", "last_name": "Irwin"}
    conversation = []

    print("Bienvenido al Chatbot Kubernetes interactivo. Escribe 'exit' para salir.\n")
    while True:
        user_input = input("Tú: ")
        if user_input.lower() in ("exit", "quit"):
            break

        # Se agrega el mensaje del usuario al historial
        conversation.append({"role": "user", "content": user_input})
        
        # Se solicita a la IA que genere el comando kubectl
        response = get_chat_response(conversation, context)
        assistant_output = response.choices[0].message.content.strip()
        print("\nComando sugerido por el asistente:")
        print(assistant_output, "\n")
        
        # Confirmar con el usuario antes de ejecutar el comando
        confirm = input("¿Ejecutar este comando? (s/n): ")
        if confirm.lower() == "s":
            execute_command(assistant_output)
        else:
            print("Comando no ejecutado.\n")
        
        # Se guarda la respuesta en el historial para mantener el contexto
        conversation.append({"role": "assistant", "content": assistant_output})
